---
name: xml
description: 안정적인 XML 스키마 정의와 데이터 교환 규칙 가이드
license: MIT
---

# XML 개발 스킬

## 기본 원칙
- XSD/DTD 스키마로 구조 고정
- 네임스페이스 충돌 방지
- UTF-8 인코딩 명시
- XPath/XSLT 테스트 자동화

## 예시 구조
```xml
<?xml version="1.0" encoding="UTF-8"?>
<catalog xmlns="https://example.com/schema/catalog" version="1.0">
    <product id="A-1001">
        <name>Sample Product</name>
        <price currency="KRW">12000</price>
        <metadata>
            <tags>
                <tag>premium</tag>
            </tags>
        </metadata>
    </product>
</catalog>
```

## 필수 체크리스트
- [ ] XML 선언과 인코딩
- [ ] 스키마 검증 (xmllint 등)
- [ ] 네임스페이스 접두사 문서화
- [ ] 특수문자 이스케이프
- [ ] XSLT/파서 성능 측정
