---
name: wordpress
description: WordPress 테마/플러그인 개발과 보안 하드닝 가이드
license: MIT
---

# WordPress 개발 스킬

## 기본 원칙
- WP Coding Standards 준수
- 플러그인 네임스페이스/프리픽스 적용
- Nonce/권한 검사 필수
- 자동화된 업데이트 테스트

## 플러그인 구조
```
my-plugin/
├── my-plugin.php
├── includes/
│   ├── class-loader.php
│   └── class-rest-controller.php
└── assets/
    └── admin.js
```

## 코드 패턴
```php
/**
 * Plugin Name: Custom API
 */

define('MY_PLUGIN_VERSION', '1.0.0');

add_action('rest_api_init', function () {
    register_rest_route('custom/v1', '/status', [
        'methods'  => 'GET',
        'permission_callback' => '__return_true',
        'callback' => function () {
            return ['version' => MY_PLUGIN_VERSION];
        }
    ]);
});
```

## 필수 체크리스트
- [ ] wp_nonce_field 사용
- [ ] esc_html__/wp_kses 필터링
- [ ] 번역 함수 (__/ _e) 적용
- [ ] composer + wp-env 문서화
- [ ] 보안 플러그인 연동
