---
name: vue
description: Vue 3 Composition API 기반 컴포넌트 설계 가이드
license: MIT
---

# Vue 개발 스킬

## 기본 원칙
- `<script setup>`사용으로 간결화
- Pinia/Query 등 상태 추상화
- SFC 구조와 스타일 스코프 관리
- Vite 기반 번들 최적화

## 컴포넌트 패턴
```vue
<template>
  <section>
    <h2>Users</h2>
    <ul>
      <li v-for="user in users" :key="user.id">{{ user.name }}</li>
    </ul>
  </section>
</template>

<script setup lang="ts">
import { onMounted, ref } from 'vue';

const users = ref([]);

onMounted(async () => {
  const res = await fetch('/api/users');
  users.value = await res.json();
});
</script>
```

## 필수 체크리스트
- [ ] defineProps/defineEmits 타입 정의
- [ ] Suspense/Transition 활용
- [ ] 글로벌 컴포넌트 최소화
- [ ] Vite env 분리
- [ ] i18n/l10n 전략 문서화
