---
name: typescript
description: TypeScript 기반 대규모 프런트엔드/백엔드 코드 품질 가이드
license: MIT
---

# TypeScript 개발 스킬

## 기본 원칙
- strict 타입 옵션 활성화
- tsconfig 경로 별칭 관리
- ESLint + Prettier 일관화
- DTO/도메인 타입 분리

## 코드 패턴
```json
// tsconfig.json (일부)
{
  "compilerOptions": {
    "target": "ES2021",
    "module": "ESNext",
    "moduleResolution": "Node",
    "strict": true,
    "baseUrl": "./src",
    "paths": {
      "@core/*": ["core/*"],
      "@api/*": ["api/*"]
    }
  }
}
```

```typescript
import type { User } from '@core/models';

export class UserService {
  constructor(private readonly client: ApiClient) {}

  async fetch(id: string): Promise<User> {
    const response = await this.client.get(`/users/${id}`);
    return response.data;
  }
}
```

## 필수 체크리스트
- [ ] strictNullChecks 활성화
- [ ] enum 대신 literal union 우선
- [ ] 타입 가드 작성
- [ ] 배포 전 tsc --noEmit 체크
- [ ] API 타입 자동 생성

## 팀 컨벤션 체크
- [ ] `tsconfig.json`에서 strict 옵션 풀세트(true)
- [ ] ESLint(Airbnb) + Prettier + Husky pre-commit 통합
- [ ] Jest + Testing Library + react-testing-library(프론트) 구성
- [ ] webpack-bundle-analyzer로 번들 크기 검증
- [ ] 타입 선언(.d.ts)과 DTO/스키마 싱크 자동화
