---
name: react
description: React 18 컴포넌트 설계와 상태 관리 전략
license: MIT
---

# React 개발 스킬

## 기본 원칙
- 함수형 컴포넌트 + Hooks
- Server Components/SSR 고려
- 상태 관리 레이어 분리 (React Query/Zustand)
- Suspense 기반 비동기 처리

## 컴포넌트 패턴
```tsx
import { Suspense } from 'react';
import { useQuery } from '@tanstack/react-query';

function UserList() {
  const { data } = useQuery({
    queryKey: ['users'],
    queryFn: fetchUsers,
    staleTime: 5 * 60 * 1000,
  });

  return (
    <ul>
      {data?.map((user) => (
        <li key={user.id}>{user.name}</li>
      ))}
    </ul>
  );
}

export default function UsersPage() {
  return (
    <Suspense fallback={<p>Loading...</p>}>
      <UserList />
    </Suspense>
  );
}
```

## 필수 체크리스트
- [ ] eslint-config-next/react-hooks 적용
- [ ] 컴포넌트 props 타입 정의
- [ ] 코드 스플리팅/라우팅 전략
- [ ] 접근성 검사 (ARIA)
- [ ] hydration 경고 모니터링
