---
name: json
description: JSON API 규약과 스키마 검증, 버저닝 전략 가이드
license: MIT
---

# JSON 개발 스킬

## 기본 원칙
- snake_case 또는 camelCase 일관 유지
- 숫자/날짜 타입 명확화 (ISO 8601)
- JSON Schema 기반 검증
- 버전 필드 포함

## 예시 페이로드
```json
{
  "version": "1.1",
  "data": {
    "id": "usr_123",
    "name": "홍길동",
    "roles": ["admin", "editor"],
    "metadata": {
      "signupAt": "2024-01-15T09:12:00Z",
      "isActive": true
    }
  }
}
```

## 필수 체크리스트
- [ ] JSON Schema 테스트
- [ ] float 대신 decimal 문자열 고려
- [ ] 배열 order 명시 여부 기록
- [ ] 최대 payload 크기 제한
- [ ] pretty/compact 동시 제공
