---
name: java
description: 엔터프라이즈 Java 애플리케이션과 Spring Boot 서비스 구조 가이드
license: MIT
---

# Java 개발 스킬

## 기본 원칙
- LTS JDK (17+) 사용 및 모듈 관리
- Gradle/Maven 기반 의존성 관리
- 계층형 아키텍처와 DI 컨테이너 활용
- SonarLint/SpotBugs 등 정적 분석 자동화

## 프로젝트 구조
```
project-name/
├── build.gradle
├── settings.gradle
├── src/
│   ├── main/java/com/example/app/
│   │   ├── AppApplication.java
│   │   ├── config/
│   │   ├── controller/
│   │   ├── service/
│   │   └── repository/
│   └── main/resources/
│       ├── application.yml
│       └── static/
└── src/test/java/com/example/app/
```

## 코드 패턴
```java
@RestController
@RequestMapping("/api/v1/users")
@RequiredArgsConstructor
public class UserController {
    private final UserService userService;

    @GetMapping
    public ResponseEntity<List<UserDto>> listUsers() {
        return ResponseEntity.ok(userService.findAll());
    }

    @PostMapping
    public ResponseEntity<UserDto> create(@Valid @RequestBody CreateUserRequest request) {
        UserDto user = userService.createUser(request);
        return ResponseEntity.status(HttpStatus.CREATED).body(user);
    }
}
```

## 필수 체크리스트
- [ ] application.yml 프로필 분리
- [ ] DTO/엔티티 변환 계층
- [ ] Bean Validation 적용
- [ ] 테스트 (JUnit + MockMvc)
- [ ] 빌드 시 CI 품질 게이트
