---
name: general
description: 모든 프로젝트에 공통으로 적용되는 개발 원칙과 베스트 프랙티스
license: MIT
---

# 범용 개발 스킬

## 프로젝트 구조
```
project-name/
├── .github/
│   └── workflows/
├── docs/
├── src/
├── tests/
├── .env.example
├── .gitignore
├── README.md
├── CHANGELOG.md
└── LICENSE
```

## Git 워크플로우
```bash
# 기능 브랜치 생성
git checkout -b feature/new-feature

# 커밋 메시지 컨벤션
git commit -m "feat: 새로운 기능 추가"
git commit -m "fix: 버그 수정"
git commit -m "docs: 문서 업데이트"
git commit -m "refactor: 코드 리팩토링"
```

## 환경 설정
```bash
# .env.example
NODE_ENV=development
API_BASE_URL=https://api.example.com
DATABASE_URL=postgresql://user:pass@localhost/db
SECRET_KEY=your-secret-key
```

## 코딩 스타일 & 도구 컨벤션
- JavaScript/TypeScript: ESLint(Airbnb) + Prettier + Husky pre-commit
- Python: Black + isort + flake8 + mypy, pyproject.toml 기준 설정
- PHP: PSR-12 + PHP_CodeSniffer + PHPStan level 8, Composer PSR-4 오토로딩
- Java: CheckStyle + SpotBugs + Google Java Format
- Go: gofmt + golint + go vet
- Rust: rustfmt + clippy (경고 0 유지)

## 테스트 & 배포 파이프라인
- 테스트: JS/Jest, Python/pytest+pytest-cov(90% 이상), PHP/PHPUnit, Java/JUnit5, Go/testing+testify, Rust/cargo test
- 배포: GitHub Actions(or GitLab CI) → Docker(Compose) → Kubernetes(or Docker Swarm)
- 모니터링: Prometheus + Grafana, 로깅/알림 일원화

## 필수 체크리스트
- [ ] README.md 작성
- [ ] .gitignore 설정
- [ ] 환경변수 분리
- [ ] 테스트 코드 작성
- [ ] 문서화
- [ ] 코드 리뷰 프로세스
- [ ] CI/CD 파이프라인
- [ ] 보안 검토
- [ ] 성능 최적화
- [ ] 에러 로깅 및 모니터링
- [ ] 컨벤션/도구 버전 주기적 업데이트

## 유지관리 / 버전 관리
- 월간: 베스트 프랙티스 및 린터 버전 점검
- 분기별: 도구 체계/CI 파이프라인 재검토 및 개선
- 연간: 전체 스킬 문서 구조 리프레시 + 신규 기술 추가
- Git으로 `/mnt/skills/user` 버전 관리하고 변경 시 팀에 공지
