---
name: express
description: Express.js API 서버와 라우팅/미들웨어 구성 가이드
license: MIT
---

# Express 개발 스킬

## 기본 원칙
- async handler + 오류 래퍼 사용
- celebrate/zod로 입력 검증
- 공통 response formatter
- Winston/Pino 로깅

## 코드 패턴
```javascript
import express from 'express';
import helmet from 'helmet';
import morgan from 'morgan';
import { errors } from 'celebrate';
import routes from './routes/index.js';
import { errorHandler } from './middleware/error.js';

const app = express();
app.use(helmet());
app.use(morgan('combined'));
app.use(express.json({ limit: '1mb' }));
app.use('/api', routes);
app.use(errors());
app.use(errorHandler);

export default app;
```

## 필수 체크리스트
- [ ] Joi/zod 검증 스키마
- [ ] async 로깅/트레이싱
- [ ] 환경별 config 분리
- [ ] 요청 제한 + gzip
- [ ] graceful shutdown 구현
