---
name: csharp
description: .NET 8 기반 백엔드 서비스와 클린 아키텍처 가이드
license: MIT
---

# C# 개발 스킬

## 기본 원칙
- Nullable reference type 활성화
- Dependency Injection 및 Configuration 분리
- Minimal API 또는 MVC 패턴 선택
- StyleCop/FxCop 규칙 준수

## 프로젝트 구조
```
src/
├── Api/
│   ├── Program.cs
│   └── appsettings.{Environment}.json
├── Application/
├── Domain/
└── Infrastructure/
```

## 코드 패턴
```csharp
var builder = WebApplication.CreateBuilder(args);

builder.Services.AddControllers();
builder.Services.AddDbContext<AppDbContext>(options =>
    options.UseSqlServer(builder.Configuration.GetConnectionString("Default")));

var app = builder.Build();

app.UseHttpsRedirection();
app.UseAuthorization();
app.MapControllers();

app.Run();
```

## 필수 체크리스트
- [ ] appsettings 보안 분리
- [ ] EF Core 마이그레이션 관리
- [ ] Health checks/Observability
- [ ] 단위/통합 테스트
- [ ] CI에서 dotnet format 검사
