---
name: bash
description: POSIX 호환 Bash 스크립트 작성과 배포 자동화 가이드
license: MIT
---

# Bash 개발 스킬

## 기본 원칙
- `set -euo pipefail` 기본 적용
- 함수 단위 모듈화 및 shellcheck 검사
- idempotent 스크립트 구현
- 환경 변수/인자 검증

## 스크립트 예시
```bash
#!/usr/bin/env bash
set -euo pipefail

usage() {
  echo "Usage: $0 --env <environment>" >&2
  exit 1
}

while [[ $# -gt 0 ]]; do
  case "$1" in
    --env)
      ENV="$2"
      shift 2
      ;;
    *)
      usage
      ;;
  esac
done

[[ -z "${ENV:-}" ]] && usage

echo "Deploying to $ENV"
```

## 필수 체크리스트
- [ ] shellcheck 통과
- [ ] 실행 권한 관리
- [ ] 임시파일 trap 정리
- [ ] ANSI 컬러 옵션화
- [ ] 로그 레벨 구분
