---
name: angular
description: Angular 독립 실행형 컴포넌트와 RxJS 기반 설계 가이드
license: MIT
---

# Angular 개발 스킬

## 기본 원칙
- Standalone Component 우선
- OnPush change detection
- RxJS pipeable operator 구성
- Nx/monorepo 구조 고려

## 코드 패턴
```ts
@Component({
  selector: 'app-users',
  standalone: true,
  imports: [CommonModule],
  template: `
    <ul>
      <li *ngFor="let user of users$ | async">{{ user.name }}</li>
    </ul>
  `,
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class UsersComponent {
  private readonly service = inject(UserService);
  readonly users$ = this.service.list().pipe(shareReplay(1));
}
```

## 필수 체크리스트
- [ ] strictTemplates 활성화
- [ ] Route-level lazy loading
- [ ] RxJS 구독 해제 패턴
- [ ] ESLint + Angular template lint
- [ ] SCAM/Standalone naming 규칙
