---
name: yaml
description: YAML 기반 설정 파일 구조와 앵커/참조 활용 가이드
license: MIT
---

# YAML 개발 스킬

## 기본 원칙
- 들여쓰기 2 spaces 일관 유지
- Anchors/aliases로 중복 최소화
- 환경별 override 분리
- 스키마 검증(kubeval, yamllint)

## 예시 설정
```yaml
base: &base
  logLevel: info
  retries: 3

services:
  api:
    <<: *base
    port: 8080
    url: https://api.example.com
  worker:
    <<: *base
    concurrency: 4
```

## 필수 체크리스트
- [ ] 탭 문자 금지
- [ ] 문자열 quote 규칙
- [ ] 주석으로 단위 명시
- [ ] CI에서 yamllint 실행
- [ ] 비밀정보는 별도 vault
