---
name: rust
description: 안전한 Rust 시스템 프로그래밍과 Cargo 워크스페이스 가이드
license: MIT
---

# Rust 개발 스킬

## 기본 원칙
- 2021 edition + clippy 경고 0개 유지
- Result/Option 기반 에러 처리
- Ownership/borrow 규칙 설계
- Cargo workspace로 모듈화

## 프로젝트 구조
```
workspace/
├── Cargo.toml
├── crates/
│   ├── api/
│   └── core/
└── target/
```

## 코드 패턴
```rust
#[derive(Debug, serde::Deserialize, serde::Serialize)]
pub struct User {
    pub id: i64,
    pub name: String,
}

pub async fn list_users(pool: &PgPool) -> anyhow::Result<Vec<User>> {
    let rows = sqlx::query_as!(User, "SELECT id, name FROM users")
        .fetch_all(pool)
        .await?;
    Ok(rows)
}
```

## 필수 체크리스트
- [ ] cargo fmt/clippy 사전 실행
- [ ] anyhow/thiserror로 에러 통합
- [ ] 테스트 + doc-test 작성
- [ ] feature flag 문서화
- [ ] unsafe 블록 감사
