---
name: powershell
description: PowerShell Core 자동화 스크립트와 모듈 설계 가이드
license: MIT
---

# PowerShell 개발 스킬

## 기본 원칙
- ScriptAnalyzer 규칙 준수
- Verb-Noun 명명 규칙
- PSResourceGet/RequiredModules 명시
- ErrorAction/try-catch로 예외 처리

## 스크립트 예시
```powershell
[CmdletBinding()]
param(
    [Parameter(Mandatory)]
    [ValidateSet('dev','stage','prod')]
    [string]$Environment
)

try {
    Write-Information "Deploy to $Environment" -InformationAction Continue
    Invoke-Command -ScriptBlock { ./scripts/deploy.ps1 -Env $args[0] } -ArgumentList $Environment
} catch {
    Write-Error $_.Exception.Message
    exit 1
}
```

## 필수 체크리스트
- [ ] UTF-8 with BOM 저장
- [ ] SecureString/SecretManagement 사용
- [ ] PSBoundParameters 검증
- [ ] Transcript 로깅
- [ ] CI에서 pwsh -Command 테스트
