---
name: nodejs
description: Node.js 백엔드 개발과 API 구축을 위한 베스트 프랙티스
license: MIT
---

# Node.js 개발 스킬

## 기본 원칙
- Express.js 프레임워크 사용
- 미들웨어 패턴 활용
- RESTful API 설계
- 보안과 성능 고려

## 기본 서버 구조
```javascript
// server.js
import express from 'express';
import helmet from 'helmet';
import cors from 'cors';
import rateLimit from 'express-rate-limit';
import { errorHandler, notFound } from './middleware/errorMiddleware.js';
import routes from './routes/index.js';

const app = express();
const PORT = process.env.PORT || 3000;

// 보안 미들웨어
app.use(helmet());
app.use(cors());

// Rate limiting
const limiter = rateLimit({
    windowMs: 15 * 60 * 1000, // 15분
    max: 100 // 요청 제한
});
app.use(limiter);

// 기본 미들웨어
app.use(express.json({ limit: '10mb' }));
app.use(express.urlencoded({ extended: true }));

// 라우트
app.use('/api', routes);

// 에러 핸들링
app.use(notFound);
app.use(errorHandler);

app.listen(PORT, () => {
    console.log(`Server running on port ${PORT}`);
});
```

## 필수 체크리스트
- [ ] 환경변수 관리 (.env)
- [ ] 보안 헤더 설정
- [ ] Rate limiting 적용
- [ ] 에러 핸들링 미들웨어
- [ ] 로깅 시스템 구축
