---
name: laravel
description: Laravel 애플리케이션 구조와 서비스 컨테이너 활용 가이드
license: MIT
---

# Laravel 개발 스킬

## 기본 원칙
- Route/Controller/Service 계층 분리
- FormRequest로 입력 검증
- Config/Env 캐시 관리
- Horizon/Queue 모니터링

## 코드 패턴
```php
// routes/api.php
Route::middleware('auth:sanctum')->group(function () {
    Route::get('/users', [UserController::class, 'index']);
    Route::post('/users', [UserController::class, 'store']);
});
```

```php
// app/Http/Controllers/UserController.php
class UserController extends Controller
{
    public function __construct(private UserService $service) {}

    public function index(): JsonResponse
    {
        return response()->json($this->service->list());
    }
}
```

## 필수 체크리스트
- [ ] config:cache / route:cache
- [ ] Request/Resource 클래스 사용
- [ ] 이벤트/리스너 로깅
- [ ] queue:work supervisor 관리
- [ ] phpstan/pint 검사
