---
name: kubernetes
description: Kubernetes 워크로드 정의와 운영 자동화를 위한 모범 사례
license: MIT
---

# Kubernetes 개발 스킬

## 기본 원칙
- 선언형 매니페스트 + GitOps
- 리소스 요청/제한 명시
- readiness/liveness 프로브 설정
- 네임스페이스/NetworkPolicy 격리

## 매니페스트 예시
```yaml
apiVersion: apps/v1
kind: Deployment
metadata:
  name: api
  namespace: production
spec:
  replicas: 3
  selector:
    matchLabels:
      app: api
  template:
    metadata:
      labels:
        app: api
    spec:
      containers:
        - name: api
          image: registry.example.com/api:1.2.0
          ports:
            - containerPort: 8080
          resources:
            requests:
              cpu: "250m"
              memory: "256Mi"
            limits:
              cpu: "500m"
              memory: "512Mi"
          readinessProbe:
            httpGet:
              path: /healthz
              port: 8080
            initialDelaySeconds: 5
            periodSeconds: 10
```

```yaml
apiVersion: v1
kind: Service
metadata:
  name: api
spec:
  selector:
    app: api
  ports:
    - port: 80
      targetPort: 8080
  type: ClusterIP
```

## 필수 체크리스트
- [ ] kubectl diff로 변경 검증
- [ ] Secret은 외부 관리
- [ ] PodDisruptionBudget 정의
- [ ] 로그/메트릭 Exporter 연동
- [ ] RBAC 최소 권한 원칙
