---
name: go
description: Go 모듈형 서비스와 동시성 패턴 베스트 프랙티스
license: MIT
---

# Go 개발 스킬

## 기본 원칙
- Go Modules + Semantic Import Versioning
- context.Context 기반 요청 수명 관리
- goroutine/pool 사용 시 sync 주의
- gofmt/golangci-lint 자동화

## 프로젝트 구조
```
project/
├── cmd/service/main.go
├── internal/
│   ├── http/
│   ├── repository/
│   └── usecase/
├── pkg/
└── go.mod
```

## 코드 패턴
```go
func main() {
    ctx, stop := signal.NotifyContext(context.Background(), os.Interrupt)
    defer stop()

    srv := &http.Server{
        Addr:    ":8080",
        Handler: routers.Init(),
    }

    go func() {
        log.Printf("server started on %s", srv.Addr)
        if err := srv.ListenAndServe(); err != nil && err != http.ErrServerClosed {
            log.Fatalf("listen: %s", err)
        }
    }()

    <-ctx.Done()
    shutdownCtx, cancel := context.WithTimeout(context.Background(), 5*time.Second)
    defer cancel()
    srv.Shutdown(shutdownCtx)
}
```

## 필수 체크리스트
- [ ] gofmt/goimports 적용
- [ ] interface 최소화
- [ ] context 타임아웃 설정
- [ ] 의존성 버전 고정
- [ ] 벤치/프로파일링
