---
name: flask
description: Flask 마이크로서비스와 블루프린트 구조화 가이드
license: MIT
---

# Flask 개발 스킬

## 기본 원칙
- App factory 패턴
- Blueprint/Service 모듈 분리
- Config 객체 계층화
- gunicorn + waitress 등 WSGI 서버 분리

## 코드 패턴
```python
from flask import Flask
from api.routes import api_bp
from core.config import Config

def create_app(config_class: type[Config] = Config) -> Flask:
    app = Flask(__name__)
    app.config.from_object(config_class)

    app.register_blueprint(api_bp, url_prefix='/api')

    @app.errorhandler(Exception)
    def handle_error(err):
        return {'message': str(err)}, 500

    return app
```

## 필수 체크리스트
- [ ] FLASK_ENV 분리
- [ ] WSGI 진입점/ASGI 변환 문서화
- [ ] request context thread safety
- [ ] Marshmallow/Schema 검증
- [ ] Observability(otel) 추가
