---
name: django
description: Django 모놀리식/멀티앱 프로젝트 구조와 설정 분리 가이드
license: MIT
---

# Django 개발 스킬

## 기본 원칙
- settings 모듈 환경 분리
- django-environ으로 비밀 관리
- CBV + Service Layer 조합
- pytest-django 테스트 자동화

## 프로젝트 구조
```
project/
├── manage.py
├── config/
│   ├── __init__.py
│   ├── settings/
│   │   ├── base.py
│   │   ├── dev.py
│   │   └── prod.py
│   └── urls.py
└── apps/
    └── users/
        ├── models.py
        ├── services.py
        ├── views.py
        └── tests/
```

## 코드 패턴
```python
# config/settings/base.py
from pathlib import Path
import environ

env = environ.Env(DEBUG=(bool, False))
BASE_DIR = Path(__file__).resolve().parent.parent.parent

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'apps.users',
]

LOGGING = {
    'version': 1,
    'handlers': {'console': {'class': 'logging.StreamHandler'}},
    'root': {'handlers': ['console'], 'level': 'INFO'},
}
```

## 필수 체크리스트
- [ ] SECRET_KEY 외부 주입
- [ ] DB/Cache 분리 설정
- [ ] django-debug-toolbar dev 한정
- [ ] manage.py check --deploy
- [ ] pytest + coverage 리포트
