---
name: css
description: 현대적인 CSS 레이아웃과 반응형 디자인을 위한 베스트 프랙티스
license: MIT
---

# CSS 개발 스킬

## 기본 원칙
- 모바일 퍼스트 접근
- Flexbox와 Grid 활용
- CSS 변수 사용
- 컴포넌트 기반 스타일링

## CSS 리셋/노멀라이즈
```css
* {
    box-sizing: border-box;
    margin: 0;
    padding: 0;
}

:root {
    --primary-color: #007bff;
    --secondary-color: #6c757d;
    --font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
}
```

## 반응형 브레이크포인트
```css
/* Mobile First */
.container { width: 100%; }

@media (min-width: 768px) { /* Tablet */ }
@media (min-width: 1024px) { /* Desktop */ }
@media (min-width: 1440px) { /* Large Desktop */ }
```

## 필수 체크리스트
- [ ] 브라우저 기본 스타일 리셋
- [ ] 반응형 디자인 적용
- [ ] Flexbox/Grid 활용
- [ ] CSS 변수 사용
- [ ] 성능 최적화
