---
name: cpp
description: 모던 C++17/20 애플리케이션과 CMake 빌드 구성 가이드
license: MIT
---

# C++ 개발 스킬

## 기본 원칙
- 스마트 포인터로 수명 관리
- RAII / noexcept 패턴 준수
- CMake Preset과 Conan 패키지 관리
- Sanitizer와 clang-tidy 도구 사용

## 프로젝트 구조
```
project/
├── CMakeLists.txt
├── cmake/
├── include/
│   └── project/
├── src/
│   └── main.cpp
└── tests/
```

## 코드 패턴
```cmake
cmake_minimum_required(VERSION 3.22)
project(example LANGUAGES CXX)

set(CMAKE_CXX_STANDARD 20)
set(CMAKE_CXX_STANDARD_REQUIRED ON)

add_library(example STATIC src/example.cpp)
target_include_directories(example PUBLIC include)

target_compile_options(example PRIVATE -Wall -Wextra -Wpedantic)
```

```cpp
int main() {
    std::unique_ptr<Service> service = std::make_unique<Service>();
    service->run();
    return 0;
}
```

## 필수 체크리스트
- [ ] 컴파일러 경고 -Werror 처리
- [ ] 주소/정적 분석 적용
- [ ] 단위 테스트 (Catch2/googletest)
- [ ] CI 캐시 전략 설정
- [ ] 패키지 라이선스 추적
