# 🚀 Claude Skills 사용자 스킬 동기화

## 📋 개요
로컬에서 개발한 사용자 정의 스킬 템플릿을 Claude Skills에 동기화하여 바로 사용할 수 있게 해주는 도구입니다.

### ✨ 주요 기능
- **25개 언어/프레임워크** 스킬 템플릿 제공
- **에러 핸들링 패턴** 및 **테스팅 예제** 포함
- **실제 프로젝트 구조** 가이드
- **자동 백업** 및 **상세 로깅**
- **사용자 권한**으로 안전하게 실행

## 🛠️ 설치 및 사용법

### 기본 사용법
```bash
# 기본 경로로 동기화 (~/.claude/skills/user)
./setup_claude_skills.sh

# 변경사항 미리보기
./setup_claude_skills.sh --dry-run

# 커스텀 경로로 동기화
./setup_claude_skills.sh --target ~/my-claude-skills
```

### 📌 주요 옵션
| 옵션 | 설명 | 예시 |
|------|------|------|
| `--dry-run` | 실제 복사 없이 수행 예정 작업 출력 | `./setup_claude_skills.sh --dry-run` |
| `--target <경로>` | 동기화 대상 경로 지정 | `./setup_claude_skills.sh --target /custom` |
| `-h`, `--help` | 도움말 출력 | `./setup_claude_skills.sh --help` |

### 🔧 환경변수
```bash
# 기본 스킬 경로 변경
export CLAUDE_SKILLS_ROOT="/my/custom/path"
./setup_claude_skills.sh
```

## 📦 포함된 스킬 템플릿

### 🌐 웹 개발
| 언어/프레임워크 | 주요 특징 |
|----------------|-----------|
| **HTML** | 시맨틱 마크업, 접근성, SEO 최적화, 반응형 이미지 |
| **CSS** | Modern CSS, Grid/Flexbox, 변수, 애니메이션 |
| **JavaScript** | ES6+, 비동기 처리, 에러 핸들링, 성능 최적화 |
| **TypeScript** | 타입 안전성, 제네릭, 데코레이터, 빌드 설정 |
| **React** | Hooks, Context, 성능 최적화, 테스팅 |
| **Vue** | Composition API, Pinia, 리액티비티, 컴포넌트 패턴 |
| **Angular** | DI, RxJS, 서비스, 가드, 폼 처리 |

### 🖥️ 백엔드 개발
| 언어/프레임워크 | 주요 특징 |
|----------------|-----------|
| **PHP** | PSR 표준, Laravel, OOP, 보안, 에러 처리 |
| **Python** | PEP8, Django/Flask, 비동기, 타입 힌트 |
| **Node.js** | Express, 미들웨어, 스트림, 클러스터링 |
| **Java** | Spring Boot, JPA, 테스팅, 디자인 패턴 |
| **C#** | .NET Core, LINQ, 비동기, 의존성 주입 |
| **Go** | 고루틴, 채널, 인터페이스, 에러 처리 |
| **Rust** | 메모리 안전성, 소유권, 트레이트, 매크로 |

### 🗄️ 데이터 & 인프라
| 기술 | 주요 특징 |
|------|-----------|
| **SQL** | 인덱싱, 조인 최적화, 트랜잭션, 보안 |
| **Docker** | 멀티스테이지 빌드, 네트워크, 볼륨 |
| **Kubernetes** | 배포, 서비스, 설정 관리, 모니터링 |

## 💾 백업 및 로그 시스템
- **자동 백업**: 기존 파일을 `~/.claude/skills/user/.backup/<타임스탬프>/`에 보관
- **상세 로그**: `~/.claude/skills/user/sync.log`에 모든 작업 기록
- **실시간 진행률**: 동기화 진행 상황을 실시간으로 표시

## ⚡ 권장 워크플로우

```bash
# 1. 변경사항 확인
git diff

# 2. 영향 범위 미리보기
./setup_claude_skills.sh --dry-run

# 3. 실제 동기화 실행
./setup_claude_skills.sh

# 4. 로그 확인
tail -f ~/.claude/skills/user/sync.log
```

## 🎯 스킬 활용 예시

### 1. 빠른 프로젝트 시작
```
Claude: "React 프로젝트를 시작해줘"
→ React 스킬 템플릿의 프로젝트 구조와 베스트 프랙티스 적용
```

### 2. 에러 핸들링 패턴
```
Claude: "JavaScript에서 API 호출 에러를 처리해줘"
→ 포함된 에러 핸들링 패턴과 retry 로직 적용
```

### 3. 테스트 코드 작성
```
Claude: "이 함수에 대한 테스트를 작성해줘"
→ 언어별 테스팅 프레임워크와 패턴 적용
```

## 🔍 트러블슈팅

### 권한 오류
```bash
❌ 대상 경로에 쓰기 권한이 없습니다
💡 해결방법: ./setup_claude_skills.sh --target ~/my-skills
```

### 백업 공간 부족
```bash
# 오래된 백업 정리
find ~/.claude/skills/user/.backup -type d -mtime +30 -exec rm -rf {} +
```

### 로그 파일 크기
```bash
# 로그 파일 rotation
mv ~/.claude/skills/user/sync.log ~/.claude/skills/user/sync.log.old
```

## 📈 고급 활용

### 커스텀 스킬 추가
1. `mnt/skills/user/` 하위에 새 폴더 생성
2. `SKILL.md` 파일 작성 (기존 템플릿 참조)
3. `setup_claude_skills.sh`의 `LANGUAGES` 배열에 추가
4. 동기화 실행

### Git 연동
```bash
# 스킬 변경사항을 git으로 관리
cd /path/to/claude_skills_user
git add mnt/skills/user/
git commit -m "스킬 템플릿 업데이트"
```
